
    using System;
    using System.Net.Http;
    using System.Net.Http.Headers;
    using System.Threading.Tasks;
    using Newtonsoft.Json;
    using System.Collections.Generic;
    
    namespace ApiCalling
    {
        class Program
        {
            static void Main(string[] args)
            {
                RunAsync().Wait();
            }
    
            static async Task RunAsync()
            {
                using (var Apiclient = new HttpClient())
                {
                    // New code:
                    Apiclient.BaseAddress = new Uri("http://api.football-data.org/");
                    Apiclient.DefaultRequestHeaders.Accept.Clear();
                    Apiclient.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
                    Apiclient.DefaultRequestHeaders.Authorization = new AuthenticationHeaderValue("X-Auth-token", "myApiCode");
    
                    // GET
                    HttpResponseMessage response = await Apiclient.GetAsync("v2/competitions");
                    if (response.IsSuccessStatusCode)
                    {
                        var json = await response.Content.ReadAsStringAsync ();
                        Console.WriteLine(json);
    
                    }
                }
            }




