using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class FarmlandManager : MonoBehaviour
{

    public float cropGrowDelay = 1f;

    public int[] cropStates;

    public GameObject farmlands;

    public Sprite cst1, cst2, cst3;

    void Start()
    {

        PrepareCropStates();

        InvokeRepeating("GrowRandomFarmland", cropGrowDelay, cropGrowDelay);

    }

    void GrowRandomFarmland()
    {

        int farmlandToGrow = Random.Range(0, 14);

        Grow(farmlandToGrow);

    }

    void Grow(int farmland)
    {

        if (cropStates[farmland] < 3)
        {

            cropStates[farmland]++;

            UpdateTexture(farmland);

        }

    }

    void UpdateTexture(int farmland)
    {

        Sprite newTexture;

        switch (cropStates[farmland])
        {
            default:
                newTexture = cst1;
                break;
            case 1:
                newTexture = cst1;
                break;
            case 2:
                newTexture = cst2;
                break;
            case 3:
                newTexture = cst3;
                break;
        }

        farmlands.transform.GetChild(farmland).transform.GetChild(1).GetComponent<Image>().sprite = newTexture;

    }

    void PrepareCropStates()
    {

        for (int i = 0; i < 15; i++)
        {

            cropStates[i] = 1;

            UpdateTexture(i);

        }

    }

    public void HarvestFarmland(GameObject farmlandGameObject)
    {

        int farmland = int.Parse(farmlandGameObject.name.Substring(9)) - 1;

        cropStates[farmland] = 1;

        UpdateTexture(farmland);

    }

}
