maxEquityDrawDown() =>
    float max_dd = 0.0
    float max_eq = strategy.equity
    max_eq := math.max(nz(max_eq[1]), strategy.equity)
    max_dd := math.min(nz(max_dd[1]), strategy.equity / max_eq - 1)
    
    max_dd

maxTradeDrawDown() =>
    tradeEntryEquity = 0.0
    maxDrawdownPercent = 0.0
    for tradeNo = 0 to strategy.closedtrades-1
        maxDrawdownPercent := math.max(maxDrawdownPercent, (strategy.closedtrades.max_drawdown(tradeNo) / (math.abs(strategy.closedtrades.size(tradeNo)) * strategy.closedtrades.entry_price(tradeNo)) * 100))
    
    maxDrawdownPercent

current_max_drawdown = maxEquityDrawDown()
current_intra_trade_dd = maxTradeDrawDown()

if (long)
    strategy.entry("L, drawdown = " + str.tostring(current_max_drawdown) + ". Intra-trade DD: " + str.tostring(current_intra_trade_dd), strategy.long)

if (short)
    entry("S, drawdown = " + str.tostring(current_max_drawdown) + ". Intra-trade DD: " + str.tostring(current_intra_trade_dd), strategy.short)