package me.altug.levelingsystem;

import me.altug.levelingsystem.data.playerData;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;
import java.io.File;
import java.io.IOException;


public final class Leveling_System extends JavaPlugin implements Listener {

    @Override
    public void onEnable() {
        // Plugin startup logic
        saveResource("config.yml", false);
        createCustomConfig();
        getCommand("level").setExecutor(new command(this));
        Bukkit.getPluginManager().registerEvents(this, this);
        Bukkit.getPluginManager().registerEvents(new boosters(), this);

    }

    private void createCustomConfig()
    {
        File createDataFile = new File(getDataFolder(), "players.yml");
        if(!createDataFile.exists())
        {
            createDataFile.getParentFile().mkdirs();
            saveResource("players.yml", false);
        }
    }

    @Override
    public void onDisable() {
        saveConfig();
    }
    @EventHandler
    private void onJoinEvent(PlayerJoinEvent event)
    {
        playerData data = new playerData();
        File dat = new File(getDataFolder().getAbsolutePath() + "/players.yml");
        FileConfiguration conf = YamlConfiguration.loadConfiguration(dat);
        if(conf.contains("players." + event.getPlayer().getUniqueId().toString()))
        {
            data.setLevel(conf.getInt("players." + event.getPlayer().getUniqueId().toString() + ".main.level"));
            data.setReq(conf.getInt("players." + event.getPlayer().getUniqueId().toString() + ".main.required"));
            data.setExp(conf.getInt("players." + event.getPlayer().getUniqueId().toString() + ".main.exp"));
            data.setBoost(conf.getInt("players." + event.getPlayer().getUniqueId().toString() + ".main.boost"));
            System.out.println("§d(Created Data for) §e" + event.getPlayer());
            System.out.println("§dLevel " + data.getLevel());
            System.out.println("§dRequired " + data.getReq());
            System.out.println("§dExperience " + data.getExp());
            System.out.println("§dBoost " + data.getBoost());
        } else {
            data.setLevel(1);
            data.setReq(50);
            data.setExp(0);
            data.setBoost(1);
            System.out.println("§d(Loaded Data for) §e" + event.getPlayer());
            System.out.println("§dLevel " + data.getLevel());
            System.out.println("§dRequired " + data.getReq());
            System.out.println("§dExperience " + data.getExp());
            System.out.println("§dBoost " + data.getBoost());

        }
        command.setPlayerData(event.getPlayer(), data);

    }
    @EventHandler
    private void onQuit(PlayerQuitEvent event)
    {
        playerData data = command.getPlayerData(event.getPlayer());
        File dat = new File(getDataFolder().getAbsolutePath() + "/players.yml");
        FileConfiguration conf = YamlConfiguration.loadConfiguration(dat);
        conf.set("players." + event.getPlayer().getUniqueId().toString() + ".main.level", data.getLevel());
        conf.set("players." + event.getPlayer().getUniqueId().toString() + ".main.required", data.getReq());
        conf.set("players." + event.getPlayer().getUniqueId().toString() + ".main.exp", data.getExp());
        conf.set("players." + event.getPlayer().getUniqueId().toString() + ".main.boost", 1);
        try {
            conf.save(dat);
            System.out.println("§d(Quit save ran for) §e" + event.getPlayer());
            System.out.println("§dLevel " + data.getLevel());
            System.out.println("§dRequired " + data.getReq());
            System.out.println("§dExperience " + data.getExp());
            System.out.println("§dBoost " + data.getBoost());
        } catch
        (IOException e){
            e.printStackTrace();
        }
        command.resPlayerData(event.getPlayer());
    }

}
