private static void PartTwo(string text)
{
    var lines = text.Split('\n');
    int sum = 0;
    var startsWithO = new[] { "one" };
    var startsWithT = new[] { "two", "three" };
    var startsWithF = new[] { "four", "five" };
    var startsWithS = new[] { "six", "seven" };
    var startsWithE = new[] { "eight" };
    var startsWithN = new[] { "nine" };
    
    var sw = Stopwatch.StartNew();

    var list = new List<int>();
    for (int i = lines.Length - 1; i >= 0; --i)
    {
        if (string.IsNullOrWhiteSpace(lines[i])) continue;
        list.Clear();
        for (var charIdx = 0; charIdx < lines[i].Length; charIdx++)
        {
            if (char.IsDigit(lines[i], charIdx))
            {
                list.Add(lines[i][charIdx] - '0');
                continue;
            }

            var validTextDigits = lines[i][charIdx] switch
            {
                'o' => startsWithO,
                't' => startsWithT,
                'f' => startsWithF,
                's' => startsWithS,
                'e' => startsWithE,
                'n' => startsWithN,
                _ => Array.Empty<string>()
            };
            
            if (validTextDigits.Length <= 0) continue;

            foreach (var textDigit in validTextDigits)
            {
                if (charIdx + textDigit.Length > lines[i].Length)
                    continue;
                
                bool match = true;

                for (int j = 0; j < textDigit.Length; j++)
                {
                    if (textDigit[j] != lines[i][charIdx + j])
                    {
                        match = false;
                        break;
                    }
                }

                if (!match) continue;
                
                int num = textDigit switch
                {
                    "one" => 1,
                    "two" => 2,
                    "three" => 3,
                    "four" => 4,
                    "five" => 5,
                    "six" => 6,
                    "seven" => 7,
                    "eight" => 8,
                    "nine" => 9,
                    _ => 0
                };
                list.Add(num);
                break;
            }
        }

        var digitValue = list[0] * 10 + list[^1];
        sum += digitValue;
    }

    Console.WriteLine($"{(int)sum}, took {sw.Elapsed.TotalMilliseconds: 0.00}ms");
}