private const string AchievingEntryIntoTheGame = "entry_into_the_game";
        private const string AchievingGameExplorer = "game_explorer";
        private const string AchievingGameHero = "game_hero";
        
        public bool IsSuccess { get; private set; }
        
        public void InitAchievements()
        {
            Social.localUser.Authenticate((success) =>
            {
                if (success)
                {
                    IsSuccess = true;
                    Debug.Log($"Success in registration");
                }
                else
                {
                    IsSuccess = false;
                    Debug.Log($"Fail in registration");
                }
            });
#if UNITY_IOS
            if(IsSuccess)
            {
                Social.LoadAchievements(ProcessLoadedAchievements);
                GameCenterPlatform.ShowDefaultAchievementCompletionBanner(true);
            }
#endif
        }

        private void ProcessLoadedAchievements(IAchievement[] achievements)
        {
            Debug.Log(achievements.Length == 0 
                ? $"no achievements found" : $"Got {achievements.Length} achievements");
        }

        public void GetAchievingEntryIntoTheGame()
        {
#if UNITY_IOS
            GetTheAchieving(AchievingEntryIntoTheGame);
#endif
        }

        public void GetAchievingGameExplorer()
        {
#if UNITY_IOS
            GetTheAchieving(AchievingGameExplorer);
#endif
        }

        public void GetAchievingGameHero()
        {
#if UNITY_IOS
            GetTheAchieving(AchievingGameHero);
#endif
        }

        public void OpenAchievemntsUI()
        {
#if UNITY_IOS
        Social.ShowAchievementsUI();
#endif
        }

        private void GetTheAchieving(string id)
        {
            if (!IsSuccess)
                return;

            Social.ReportProgress(id, 100.0f, (access)
                => Debug.Log($"Achievement earned: {id}"));
        }
    }