            for (int i = 0; i < TotalObjects; i++)
            {
                CurrentObject = ChildObjects[i];
                mesh = new Mesh();
                if (CurrentObject.GetComponent<MeshFilter>() != null)
                    mesh = CurrentObject.GetComponent<MeshFilter>().sharedMesh;
                else
                    CurrentObject.GetComponent<SkinnedMeshRenderer>().BakeMesh(mesh, true);

                submeshcount = mesh.subMeshCount;
                int VertexCount = mesh.vertexCount;
                int IndexCount = (int)mesh.GetIndexCount(0);
                for(int i2 = 1; i2 < submeshcount; i2++) {
                    IndexCount += (int)mesh.GetIndexCount(i2);
                }
                ComputeBuffer Vector4Buffer = new ComputeBuffer(VertexCount, 16);
                ComputeBuffer Vector3Buffer = new ComputeBuffer(VertexCount, 12);
                ComputeBuffer Vector2Buffer = new ComputeBuffer(VertexCount, 8);
                ComputeBuffer Vector1Buffer = new ComputeBuffer(IndexCount, 4);
                Vector4[] Vector4Array = new Vector4[VertexCount];
                Vector3[] Vector3Array = new Vector3[VertexCount];
                Vector2[] Vector2Array = new Vector2[VertexCount];
                int[] Vector1Array = new int[IndexCount];
                mesh.vertexBufferTarget |= GraphicsBuffer.Target.Raw;
                mesh.indexBufferTarget |= GraphicsBuffer.Target.Raw;
                UnityEngine.Rendering.VertexAttributeDescriptor[] Attributes = mesh.GetVertexAttributes();
                int VertexAttributeCount = Attributes.Length;
                GetVertData.SetInt("Count", VertexCount);
                int IndexOffset = CurMeshData.Verticies.Count;
                for(int i2 = 0; i2 < VertexAttributeCount; i2++) {
                    GraphicsBuffer MeshBuffer = mesh.GetVertexBuffer(Attributes[i2].stream);
                    GetVertData.SetBuffer(Attributes[i2].dimension - 1, "GraphicsBuffer", MeshBuffer);
                    GetVertData.SetInt("Stride", mesh.GetVertexBufferStride(Attributes[i2].stream));
                    GetVertData.SetInt("AttributeOffset", mesh.GetVertexAttributeOffset(Attributes[i2].attribute));
                    switch(Attributes[i2].attribute) {
                        case UnityEngine.Rendering.VertexAttribute.Position:
                            GetVertData.SetBool("Is16Bit", false);
                            if(Attributes[i2].format != UnityEngine.Rendering.VertexAttributeFormat.Float32) {
                                Debug.Log("Wrong Vertex Attribute Format, needs to be Float32");
                                return;
                            }
                            GetVertData.SetBuffer(2, "Output3", Vector3Buffer);
                            GetVertData.Dispatch(2, (int)Mathf.CeilToInt(VertexCount / 1023.0f), 1, 1);
                            Vector3Buffer.GetData(Vector3Array);
                            CurMeshData.Verticies.AddRange(Vector3Array);
                        break;
                        case UnityEngine.Rendering.VertexAttribute.Normal:
                            GetVertData.SetBool("Is16Bit", Attributes[i2].format == UnityEngine.Rendering.VertexAttributeFormat.Float16);
                            GetVertData.SetBuffer(2, "Output3", Vector3Buffer);
                            GetVertData.Dispatch(2, (int)Mathf.CeilToInt(VertexCount / 1023.0f), 1, 1);
                            Vector3Buffer.GetData(Vector3Array);
                            CurMeshData.Normals.AddRange(Vector3Array);
                        break;
                        case UnityEngine.Rendering.VertexAttribute.Tangent:
                        GetVertData.SetBool("Is16Bit", false);
                            if(Attributes[i2].format != UnityEngine.Rendering.VertexAttributeFormat.Float32) {
                                Debug.Log("Wrong Vertex Attribute Format, needs to be Float32");
                                return;
                            }
                            GetVertData.SetBuffer(3, "Output4", Vector4Buffer);
                            GetVertData.Dispatch(3, (int)Mathf.CeilToInt(VertexCount / 1023.0f), 1, 1);
                            Vector4Buffer.GetData(Vector4Array);
                            CurMeshData.Tangents.AddRange(Vector4Array);
                        break;
                        case UnityEngine.Rendering.VertexAttribute.TexCoord0:
                            GetVertData.SetBool("Is16Bit", Attributes[i2].format == UnityEngine.Rendering.VertexAttributeFormat.Float16);
                            GetVertData.SetBuffer(1, "Output2", Vector2Buffer);
                            GetVertData.Dispatch(1, (int)Mathf.CeilToInt(VertexCount / 1023.0f), 1, 1);
                            Vector2Buffer.GetData(Vector2Array);
                            CurMeshData.UVs.AddRange(Vector2Array);
                        break;
                        case UnityEngine.Rendering.VertexAttribute.TexCoord1:
                            GetVertData.SetBool("Is16Bit", Attributes[i2].format == UnityEngine.Rendering.VertexAttributeFormat.Float16);
                            GetVertData.SetBuffer(1, "Output2", Vector2Buffer);
                            GetVertData.Dispatch(1, (int)Mathf.CeilToInt(VertexCount / 1023.0f), 1, 1);
                            Vector2Buffer.GetData(Vector2Array);
                            if(CurrentObject.GetComponent<MeshRenderer>() != null) CurMeshData.FillMapUVsScaled(Vector2Array, CurrentObject.GetComponent<MeshRenderer>().lightmapScaleOffset);
                            break;
                    }
                    MeshBuffer.Dispose();
                }
                GraphicsBuffer IndexBuffer = mesh.GetIndexBuffer();
                GetVertData.SetBuffer(0, "GraphicsBuffer", IndexBuffer);

                int PreIndexLength = CurMeshData.Indices.Count;
                GetVertData.SetInt("Count", IndexCount);
                GetVertData.SetBool("Is16Bit", mesh.indexFormat == UnityEngine.Rendering.IndexFormat.UInt16);
                GetVertData.SetBuffer(0, "Output1", Vector1Buffer);
                GetVertData.Dispatch(0, (int)Mathf.CeilToInt(IndexCount / 1023.0f), 1, 1);
                Vector1Buffer.GetData(Vector1Array);
                CurMeshData.Indices.AddRange(Vector1Array);

                if (!mesh.HasVertexAttribute(UnityEngine.Rendering.VertexAttribute.TexCoord0)) CurMeshData.SetUvZero(VertexCount);
                if(!mesh.HasVertexAttribute(UnityEngine.Rendering.VertexAttribute.Tangent)) CurMeshData.SetTansZero(VertexCount);

                #if DoLightMapping
                    CurMeshData.FillMapIndexes(VertexCount, CurrentObject.GetComponent<MeshRenderer>().lightmapIndex);
                #else
                    CurMeshData.SetLightMapUvZero(VertexCount);
                    CurMeshData.FillMapIndexes(VertexCount, -1);
                #endif
                IndexBuffer.Dispose();
                Vector4Buffer.Dispose();
                Vector3Buffer.Dispose();
                Vector2Buffer.Dispose();
                Vector1Buffer.Dispose();

                int TotalIndexLength = 0;
                for (int i2 = 0; i2 < submeshcount; ++i2)
                {//Add together all the submeshes in the mesh to consider it as one object
                    int IndiceLength = (int)mesh.GetIndexCount(i2) / 3;
                    MatIndex = i2 + RepCount;
                    TotalIndexLength += IndiceLength;
                    var SubMesh = new int[IndiceLength];
                    System.Array.Fill(SubMesh, MatIndex);
                    CurMeshData.MatDat.AddRange(SubMesh);
                }
                if (IsSkinnedGroup)
                {
                    IndexCounts[i] = TotalIndexLength;
                    SkinnedMeshes[i] = ChildObjects[i].GetComponent<SkinnedMeshRenderer>();
                    SkinnedMeshes[i].updateWhenOffscreen = true;
                    TotalTriangles += TotalIndexLength;
                }
                TransformIndexes.Add(new MeshTransformVertexs()
                {
                    VertexStart = PreIndexLength,
                    VertexCount = CurMeshData.Indices.Count - PreIndexLength,
                    IndexOffset = IndexOffset
                });
                RepCount += submeshcount;
            }
        }
