import ../../GL/opengl

type
  VertexArrayObject* = object
    vaoID*, bufferID, elementID: GLuint
    vertices*: seq[GLfloat]
    indices*: seq[GLuint]

proc bindData*(VAO: var VertexArrayObject) = 
    
  glGenVertexArrays(1, unsafeAddr VAO.vaoID)
  glGenBuffers(1, unsafeAddr VAO.bufferID)
  glGenBuffers(1, unsafeAddr VAO.elementID)

  glBindVertexArray(VAO.vaoID)

  glBindBuffer(GL_ARRAY_BUFFER, VAO.bufferID)
  glBufferData(GL_ARRAY_BUFFER, GLfloat.sizeof * VAO.vertices.len, unsafeAddr VAO.vertices, GL_STATIC_DRAW)

  glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, VAO.elementID)
  glBufferData(GL_ELEMENT_ARRAY_BUFFER, GLuint.sizeof * VAO.indices.len, unsafeAddr VAO.indices, GL_STATIC_DRAW)

  glVertexAttribPointer(0, 3, EGL_FLOAT, false, GLfloat.sizeof * 3, nil)
  glEnableVertexAttribArray(0)
  
proc render*(VAO: var VertexArrayObject) =
  glBindVertexArray(VAO.vaoID)
  glDrawElements(GL_TRIANGLES, GLsizei VAO.indices.len, GL_UNSIGNED_INT, nil)
