//@version=5
strategy("BTC NANDORFEHERVAR", overlay=false, initial_capital=10000, default_qty_type=strategy.percent_of_equity, default_qty_value=100, pyramiding=0, slippage=1)

// ELiCobra Metrics Import
import EliCobra/CobraMetrics/4 as cobra
//// PLOT DATA
disp_ind = input.string ("None" , title = "Display Curve" , tooltip = "Choose which data you would like to display", options=["Strategy", "Equity", "Open Profit", "Gross Profit", "Net Profit", "None"], group = "🐍 𝓒𝓸𝓫𝓻𝓪 𝓜𝓮𝓽𝓻𝓲𝓬𝓼 🐍")
pos_table = input.string("Middle Left", "Table Position", options = ["Top Left", "Middle Left", "Bottom Left", "Top Right", "Middle Right", "Bottom Right", "Top Center", "Bottom Center"], group = "🐍 𝓒𝓸𝓫𝓻𝓪 𝓜𝓮𝓽𝓻𝓲𝓬𝓼 🐍")
type_table = input.string("None", "Table Type", options = ["Full", "Simple", "None"], group = "🐍 𝓒𝓸𝓫𝓻𝓪 𝓜𝓮𝓽𝓻𝓲𝓬𝓼 🐍")
plot(cobra.curve(disp_ind))
cobra.cobraTable(type_table, pos_table)

startTime   = input.time(title="Start Filter", defval=timestamp("01 Jan 2018 19:30 +0000"), group="Time Filter", tooltip="Start date & time to begin searching for setups")
endTime     = input.time(title="End Filter", defval=timestamp("1 Jan 2099 19:30 +0000"), group="Time Filter", tooltip="End date & time to stop searching for setups")
dateFilter(int st, int et) => time >= st and time <= et
// #1 
g_stc ="Schaff Trend Cycle"
EEEEEE = input(13, 'Length',group = g_stc)
BBBB = input(31, 'FastLength',group = g_stc)
BBBBB = input(70, 'SlowLength',group = g_stc)

AAAA(BBB, BBBB, BBBBB) =>
    fastMA = ta.ema(BBB, BBBB)
    slowMA = ta.ema(BBB, BBBBB)
    AAAA = fastMA - slowMA
    AAAA

AAAAA(EEEEEE, BBBB, BBBBB) =>
    AAA = 0.5
    var CCCCC = 0.0
    var DDD = 0.0
    var DDDDDD = 0.0
    var EEEEE = 0.0
    BBBBBB = AAAA(close, BBBB, BBBBB)
    CCC = ta.lowest(BBBBBB, EEEEEE)
    CCCC = ta.highest(BBBBBB, EEEEEE) - CCC
    CCCCC := CCCC > 0 ? (BBBBBB - CCC) / CCCC * 100 : nz(CCCCC[1])
    DDD := na(DDD[1]) ? CCCCC : DDD[1] + AAA * (CCCCC - DDD[1])
    DDDD = ta.lowest(DDD, EEEEEE)
    DDDDD = ta.highest(DDD, EEEEEE) - DDDD
    DDDDDD := DDDDD > 0 ? (DDD - DDDD) / DDDDD * 100 : nz(DDDDDD[1])
    EEEEE := na(EEEEE[1]) ? DDDDDD : EEEEE[1] + AAA * (DDDDDD - EEEEE[1])
    EEEEE

mAAAAA = AAAAA(EEEEEE, BBBB, BBBBB)

//LONG
STClong1 = (mAAAAA > mAAAAA[1])
//STClong2 = ta.crossover(mAAAAA,mAAAAA[1])

//SHORT
STCshort1 = (mAAAAA < mAAAAA[1])
//STCshort2 = ta.crossunder(mAAAAA,mAAAAA[1])

// #2 RWI
length = input.int(title="Length",  defval=32, minval=1,group = "RWI")

rwiHigh = (high - nz(low[length])) / (ta.atr(length) * math.sqrt(length))
rwiLow = (nz(high[length]) - low) / (ta.atr(length) * math.sqrt(length))

bullCO= ta.crossover(rwiHigh,rwiLow)
shortCU = ta.crossunder(rwiHigh,rwiLow)
rwiLong = rwiHigh > rwiLow
rwiShort = rwiLow > rwiHigh 

// FILTERING #3 Trend Step - Trailing
g_ts = "Trend Step - Trailing "
matype = input.string("WMA",  title="MA Type", options=["WMA"],group = g_ts)
len = input.int(53, minval=2, title='Length',group = g_ts)
Step = input.int(50, minval=0, title='Step Size [Ticks]',group = g_ts) * syminfo.mintick  // The syminfo.mintick variable returns the minimum tick value for the instrument that the script calculates on (TradingView, n.d.). That value is the instrument’s smallest possible price movement. We can use the syminfo.mintick variable in indicator (study) and strategy scripts.


ma(type)=>
    float ma = switch type
        "WMA" => ta.wma(close, len)
        // Default 
        => ta.sma(close, len)


set_ma = ma(matype)
varip MA = close
if set_ma > MA + Step
    MA := set_ma
    MA
else if set_ma < MA - Step
    MA := set_ma
    MA

stepLong1 = set_ma[1]<set_ma
stepShort1 = set_ma[1]>set_ma
stepLong2 = ta.crossover(set_ma,set_ma[1])
stepShort2 =ta.crossunder(set_ma,set_ma[1])

//#4  QSTICK
Length = input.int(61, minval=1,group = "QSTICK")
xR = close - open
xQstick = ta.sma(xR, Length)


qLong2 = ta.crossover(xQstick,0)
qLong1 = xQstick > 0

qShort1 = ta.crossunder(xQstick,0)
qShort2 = xQstick < 0

// #5 DECYCLER

g_d = "Decycler"
highpassLength = input.int(title="Highpass Period", defval=50,group =g_d )
srcd = input(title="Source", defval=close,group = g_d)

PI = 2 * math.asin(1)

// High-pass Filter
alphaArg = 2 * PI / (highpassLength * math.sqrt(2))

alpha = 0.0
alpha := math.cos(alphaArg) != 0
     ? (math.cos(alphaArg) + math.sin(alphaArg) - 1) / math.cos(alphaArg)
     : nz(alpha[1])

hp = 0.0
hp := math.pow(1 - (alpha / 2), 2) * (srcd - 2 * nz(srcd[1]) + nz(srcd[2])) + 2 * (1 - alpha) * nz(hp[1]) - math.pow(1 - alpha, 2) * nz(hp[2])

decycler = srcd - hp

decLong = decycler >= decycler[1]
decShort = decycler < decycler[1]
//#6 ARSI
lengthr = input.int(title="RSI LENGTH", defval=135,group = "RSI")
alphar = 2 * math.abs(ta.rsi(close, lengthr) / 100 - 0.5)
arsi = 0.0
arsi := alphar * close + (1 - alphar) * nz(arsi[1])
aRSIlong = arsi > arsi[1]
aRSIshort = arsi <= arsi[1]
//#7 DMI 
lenD = input.int(14, minval=1, title="DI Length")
lensig = input.int(14, title="ADX Smoothing", minval=1, maxval=50)

up = ta.change(high)
down = -ta.change(low)
plusDM = na(up) ? na : (up > down and up > 0 ? up : 0)
minusDM = na(down) ? na : (down > up and down > 0 ? down : 0)
trur = ta.rma(ta.tr, lenD)
plus = fixnan(100 * ta.rma(plusDM, lenD) / trur)
minus = fixnan(100 * ta.rma(minusDM, lenD) / trur)
sum = plus + minus
adx = 100 * ta.rma(math.abs(plus - minus) / (sum == 0 ? 1 : sum), lensig)
diLong = plus >= minus
diShort = plus < minus
//ENTER 
longEn = (STClong1 and rwiLong and aRSIlong ) or (decLong and rwiLong) 
shortEn = (STCshort1 and rwiShort and stepShort1 and aRSIshort) or (stepShort2 and qShort2)


//

var color barColor = color.rgb(180, 180, 180)

//ENTER
if longEn and dateFilter(startTime,endTime)
    strategy.entry("Long",strategy.long)
    barColor := #2DD204
if shortEn and dateFilter(startTime,endTime)
    strategy.entry("Short",strategy.short)
    barColor := #D2042D

//Monitoring trades
plot(STClong1 ? 100 : STCshort1 ? 98 : 99,color = color.purple,linewidth = 2,title = "STC")
plot(rwiLong ? 97 : rwiShort ? 95 : 96,color = color.yellow,linewidth = 2,title = "RWI")
plot(stepLong2 ? 94 : stepShort2 ? 92 : 93,color = color.blue,linewidth = 2,title = "TREND STEP")
plot(qLong1 ? 91 : qShort2 ? 89 : 91,color = color.green,linewidth = 2,title = "QSTICK")
plot(decLong ? 88 : decShort ? 86 : 87,color = color.orange,linewidth = 2,title = "Decycler")

//plotcandle(open,high,low,close, color = barColor, bordercolor = barColor, wickcolor = barColor)