      case TopicNarrow(:var streamId, :var topic):
        final store = PerAccountStoreWidget.of(context);
        final stream = store.streams[streamId];
        final alignment = willCenterTitle
          ? Alignment.center
          : AlignmentDirectional.centerStart;
        return SizedBox(
          width: double.infinity,
          child: GestureDetector(
            behavior: HitTestBehavior.translucent,
            onLongPress: () {
              final someMessage = MessageListPage.ancestorOf(context)
                .model?.messages.lastOrNull;
              // If someMessage is null, the topic action sheet won't have a
              // resolve/unresolve button. That seems OK; in that case we're
              // either still fetching messages (and the user can reopen the
              // sheet after that finishes) or there aren't any messages to
              // act on anyway.
              assert(someMessage == null || narrow.containsMessage(someMessage)!);
              showTopicActionSheet(context,
                channelId: streamId,
                topic: topic,
                someMessageIdInTopic: someMessage?.id);
            },
            child: Align(alignment: alignment,
              child: stream == null
                ? Text(zulipLocalizations.unknownChannelName)
                : Text.rich(
                    channelTopicLabelSpan(
                      context: context,
                      channelId: streamId,
                      topic: topic,
                      fontSize: 16,
                      color: colorSwatchFor(context, store.subscriptions[streamId])
                        .iconOnBarBackground,
                    )))));