      streamWidget = GestureDetector(
        onTap: () => Navigator.push(context,
          MessageListPage.buildRoute(context: context,
            narrow: ChannelNarrow(streamId))),
        onLongPress: () => showChannelActionSheet(context, channelId: streamId),
        child: Padding(
          padding: const EdgeInsets.symmetric(vertical: 11),
          child: Text.rich(
            style: recipientHeaderTextStyle(context),
            overflow: TextOverflow.ellipsis,
            channelTopicLabelSpan(
              context: context,
              channelId: streamId,
              topic: topic,
              fontSize: recipientHeaderTextStyle(context).fontSize!,
              color: recipientHeaderTextStyle(context).color!,
            )));
    }


    return GestureDetector(
      // When already in a topic narrow, disable tap interaction that would just
      // push a MessageListPage for the same topic narrow.
      // TODO(#1039) simplify by removing topic-narrow condition if we remove
      //   recipient headers in topic narrows
      onTap: narrow is TopicNarrow ? null
        : () => Navigator.push(context,
            MessageListPage.buildRoute(context: context,
              narrow: TopicNarrow.ofMessage(message))),
      onLongPress: () => showTopicActionSheet(context,
        channelId: streamId,
        topic: topic,
        someMessageIdInTopic: message.id),
      child: ColoredBox(
        color: backgroundColor,
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            // TODO(#282): Long stream name will break layout; find a fix.
            Expanded(child: streamWidget),
            // TODO topic links?
            // Then web also has edit/resolve/mute buttons. Skip those for mobile.
            RecipientHeaderDate(message: message),
          ])));