  Widget _buildStreamRow(BuildContext context, {
    ZulipStream? stream,
  }) {
    final store = PerAccountStoreWidget.of(context);
    final zulipLocalizations = ZulipLocalizations.of(context);

    if (stream == null) {
      return Text(zulipLocalizations.unknownChannelName);
    }

    return Text.rich(
      channelTopicLabelSpan(
        context: context,
        channelId: stream.streamId,
        fontSize: 16,
        color: colorSwatchFor(context, store.subscriptions[stream.streamId])
          .iconOnBarBackground,
      ));
  }