// This Pine Script™ code is subject to the terms of the Mozilla Public License 2.0 at https://mozilla.org/MPL/2.0/
// © TyBoar
//@version=5


strategy("DMI",
     shorttitle="DMI",
     overlay=true,
     format=format.price,
     precision=2,
     default_qty_type= strategy.percent_of_equity,
     initial_capital = 1000000,
     currency = "USD",
     slippage= 1,
     default_qty_value = 100
     )
var INP ="Indicator Inputs"


                        //-------------------COBRA METRICS AND DISPLAY-------------------


// Plot Cobra Metrics Table


import MeiniacLol/MysteryMetrics/2 as skuby


// import EliCobra/CobraMetrics/4 as cobra




disp_ind = input.string ("Strategy" , title = "Display Curve" , tooltip = "Choose which data you would like to display",
      options=["Strategy", "Equity", "Open Profit", "Gross Profit", "Net Profit", "None"],
      group = "🐍 𝓒𝓸𝓫𝓻𝓪 𝓜𝓮𝓽𝓻𝓲𝓬𝓼 🐍")
pos_table = input.string("Top Right", "Table Position",
      options = ["Top Left", "Middle Left", "Bottom Left", "Top Right", "Middle Right", "Bottom Right", "Top Center", "Bottom Center"],
      group = "🐍 𝓒𝓸𝓫𝓻𝓪 𝓜𝓮𝓽𝓻𝓲𝓬𝓼 🐍")
type_table = input.string("Full", "Table Type", options = ["Full", "Simple", "None"], group = "🐍 𝓒𝓸𝓫𝓻𝓪 𝓜𝓮𝓽𝓻𝓲𝓬𝓼 🐍")


// plot(cobra.curve(disp_ind), color = color.rgb(213, 213, 213))
// cobra.cobraTable(type_table, pos_table)


plot(skuby.curve(disp_ind), color = color.rgb(213, 213, 213))
skuby.cobraTable(type_table, pos_table)


// Date Range
start_date  = input.int(title=  'Start Date', defval=1, minval=1, maxval=31, group='Date Range', inline='1')
start_month = input.int(title= 'Start Month', defval=1, minval=1, maxval=12, group='Date Range', inline='2')
start_year  = input.int(title=  'Start Year', defval=2018, minval=1800, maxval=3000, group='Date Range', inline='3')
end_date    = input.int(title=    'End Date', defval=1, minval=1, maxval=31, group='Date Range', inline='1')
end_month   = input.int(title=   'End Month', defval=1, minval=1, maxval=12, group='Date Range', inline='2')
end_year    = input.int(title=    'End Year', defval=2077, minval=1800, maxval=3000, group='Date Range', inline='3')


Time_Range  = time >= timestamp(syminfo.timezone, start_year, start_month, start_date, 0, 0)
          and time <  timestamp(syminfo.timezone,   end_year,   end_month,   end_date, 0, 0)




                              //-------------------INDICATOR-------------------
ShowP      = input.bool(false,"Show+")
ShowM      = input.bool(false,"Show-")
ShowX      = input.bool(false,"ShowADX")
ShowT      = input.bool(false,"Show Threshold")  


// Calculate IFT on CCI
length = input.int(title="CCI Length", defval=20)
src = close
cc=ta.cci(src, length)
lengthwma=input(9, title="Smoothing length")




// calc_ifish(series, lengthwma) =>
//     v1 =0.1*(series-50)
//     v2=ta.wma(v1,lengthwma)
//     ifish=(math.exp(2*v2)-1)/(math.exp(2*v2)+1)
//     ifish


// plot(calc_ifish(cc, lengthwma), color=color.teal, linewidth=1)
// hline(0.5, color=color.red)
// hline(-0.5, color=color.green)
// hline(0)


// FISHL= calc_ifish(cc, lengthwma) <= -0.5


// FISHS= calc_ifish(cc, lengthwma) >=  0.5




//-------------------DMI-------------------


len        = input(10, "DI Length")
//  ruhroh =38
adx_factor = input.int(9,"ADX factor",minval=1, maxval=50)
// ruroh=13
Threshold  = input(22,"Threshold")
Threshold2 = input(50,"Threshold")


// xHL2 = input(hl2) -> try it with ohlc4


[plus, minus, adx] = ta.dmi(len, adx_factor)
Length = input.int(10, minval=1)


Fisher(ser, Length) =>
    H =ta.highest(ser,Length)
    L=ta.lowest(ser,Length)
    nValue = 0.33 * 2 * ((ser - L) / (H - L) - 0.5)
    nValue1 = nValue + 0.67*nz(nValue[1])
    nValue2 = nValue1 > 0.99 ? 0.999  : nValue1 < -0.99 ? -0.999 : nValue1
    nFish = 0.5 * math.log((1 + nValue2) / (1 - nValue2))
    Fish = nFish + 0.5*nz(nFish[1])


// plot(Fish,"Fisher", color.green)
// plot(nz(Fish[1]),"Trigger", color.red)


// PLOT
// plot(  ShowP==true? plus  :na,   "DI+", color.green)
// plot(  ShowM==true? minus :na,   "DI-", color.red  )
// plot(  ShowX==true? adx   :na,   "ADX", color.blue )
// hline( ShowT==true? Threshold  :na, color=color.new(color.gray,75))
// hline( ShowT==true? Threshold2 :na, color=color.new(color.gray,75))


// -----------------------------------------------------------------------------------------------------------------


ADXU= adx > adx[1]
ADXD= adx[1] > adx
DMIL= plus>plus[1] and plus>plus[2]
DMIS= minus>minus[1] and minus>minus[2]
ADXTSH= adx >Threshold
PTSH= plus> Threshold
MTSH= minus> Threshold


adxPX = ta.cross(adx,plus)
adxMX = ta.cross(adx,minus)
PMX = ta.cross(plus,minus)
adxX  = ta.cross(adx,Threshold2)


ADXDMIL = ((PMX and DMIL) or (adxPX and PTSH and ADXTSH and ADXU)or (adxX and ADXU))


ADXDMIS = ((PMX and DMIS) or (adxMX and MTSH and ADXTSH) or (adxX and ADXD))




Long= ADXDMIL


Short= ADXDMIS


                            //-------------------STRATEGY-------------------




   
// Overall
Valid_Ind = not na(plus) and not na(minus) and not na(adx)




longCondition = Time_Range
     and strategy.equity > 0
     and barstate.isconfirmed
     and Valid_Ind
     and Long


shortCondition = Time_Range
     and strategy.equity > 0
     and barstate.isconfirmed
     and Valid_Ind
     and Short


Valhalla = longCondition
Midgard  = shortCondition




// Main logic
if Valhalla
    strategy.entry("Valhalla", strategy.long, alert_message="ONWARDS!")




if Midgard
    strategy.entry("Midgard", strategy.short, alert_message="REGROUP!")









