package Ticket;

import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;

import javax.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TicketResponse extends ListenerAdapter {
    public boolean typeDeclared = false;
    public String typeReport = "";
    public int msgCount = 0;
    public String msg;
    public String[] input;
    public List<Message.Attachment> attachment;
    public boolean isAttachment = false;

    @Override
    public void onMessageReactionAdd(@Nonnull MessageReactionAddEvent event) {
        MessageChannel channel = event.getReaction().getChannel();

        String[] checkForTicket = channel.getName().split("-");

        if(checkForTicket[0].equalsIgnoreCase("ticket"))
        {
            if(!Objects.requireNonNull(event.getUser()).isBot() && !this.typeDeclared)
            {
                //event.getReaction().removeReaction(NewTicket.user).queue();
                switch (event.getReactionEmote().getName())
                {
                    case "\ud83c\udfae":
                        event.getChannel().sendMessage("Ok! Please provide the name of the hacker in the first message, and the evidence in the second message.").queue();
                        this.typeReport = "Hacker";
                        break;

                    case "\ud83d\udc1b":
                        event.getChannel().sendMessage("Ok! Please describe the bug, and **elaborate**, please. You may also provide evidence.").queue();
                        this.typeReport = "Bug";
                        break;

                    case "\ud83d\udcac":
                        event.getChannel().sendMessage("Ok! Please describe your suggestion. You may also provide files to help convey your suggestion.").queue();
                        this.typeReport = "Suggestion";
                        break;
                }
                this.typeDeclared = true;
            }
        }
    }

    @Override
    public void onGuildMessageReceived(@Nonnull GuildMessageReceivedEvent event) throws NullPointerException
    {
        String[] checkForTicket = event.getChannel().getName().split("-");

        if(typeDeclared && checkForTicket[0].equalsIgnoreCase("ticket") && !event.getAuthor().isBot())
        {
            this.msgCount++;

            System.out.println(this.msgCount);

            if(event.getMessage().getAttachments().isEmpty())
            {
                System.out.println(Arrays.toString(event.getMessage().getContentDisplay().split(" ")));

                String message = event.getMessage().getContentDisplay();

                this.msg += "|" + message;

                this.input = this.msg.split("\\|");
            }
            else if(this.msgCount == 1 && !event.getMessage().getAttachments().isEmpty())
            {
                this.attachment = event.getMessage().getAttachments();
                this.isAttachment = true;
            }

            if(this.msgCount == 2 && this.typeReport.equals("Hacker"))
            {
                event.getChannel().sendMessage("Just one more thing, is this in Minecraft, Discord, or both?").queue();
            }

            if(this.msgCount == 3)
            {
                EmbedBuilder embed = new EmbedBuilder();

                if(this.typeReport.equals("Hacker"))
                {
                    if(this.isAttachment)
                    {
                        embed.setTitle("Transcript for " + event.getChannel().getName());
                        embed.setDescription("Type of Report: " + this.typeReport);
                        embed.addField("**Name of Hacker:**", this.input[1], true);
                        for(Message.Attachment a : this.attachment)
                        {
                            embed.setImage(a.getUrl());
                        }
                        embed.addField("**MC OR DISCORD:**", this.input[3], true);
                    }
                    else if (!this.isAttachment)
                    {
                        embed.setTitle("Transcript for " + event.getChannel().getName());
                        embed.setDescription("Type of Report: " + this.typeReport);
                        embed.addField("**Name of Hacker:**", this.input[1], true);
                        embed.addField("**Evidence:**", this.input[2], false);
                        embed.addField("**MC OR DISCORD:**", this.input[3], true);
                    }
                }
                event.getChannel().sendMessage(embed.build()).queue();
            }
        }
    }
}
