mstdSource          = input.source(close, title="Median Source", group = mstdGroup)
mstdLength          = input.int(65, title="Median Length", group = mstdGroup)
mstdAtrLength       = input.int(14, title="ATR Length", group = mstdGroup)
mstdAtrMult         = input.float(0.5, step = 0.1, title="ATR Multiplier", group = mstdGroup)

stdMedian = ta.percentile_nearest_rank(mstdSource, mstdLength, 50)
// mstdMedianPlot = plot(mstdMedian, color=color.red, linewidth=3, title="Median")

mstdAtr = mstdAtrMult * ta.atr(mstdAtrLength)

// plot(mstdMedian + mstdAtr, color=color.lime, title="Upper Band")
// plot(mstdMedian - mstdAtr, color=color.fuchsia, title="Lower Band")

mstdMedianEma = ta.ema(mstdMedian, mstdLength)
// mstdEmaPlot = plot(mstdMedianEma, color=color.blue, title="Median EMA")


mstdMedianL = mstdMedian > mstdMedianEma
mstdMedianS = mstdMedian < mstdMedianEma

mstdUpperBand = mstdMedian + mstdAtr
mstdLowerBand = mstdMedian - mstdAtr

medianupper = close > mstdLowerBand  
medianlower = close < mstdUpperBand