public TMP_Text amountText;
    public int amount;
    public GameManager gameManager;
    private SpriteRenderer spriteRenderer;
    public SnakeTail snakeTail;
    public GameObject EffectPrefab;
    public float t;

    private void Start()
    {
        EffectPrefab.SetActive(false);
        spriteRenderer = GetComponent<SpriteRenderer>();
        SetAmount();
    }
    private void Update()
    {
    }
    public void SetAmount() 
    {
        gameObject.SetActive(true);
        amount = Random.Range(0, gameManager.maxAmountBlock);
        SetAmountText();
        SetColor();
    }
    private void SetAmountText() 
    {
        amountText.text = amount.ToString();
    }
    public void SetColor() 
    {
        float PlayerLives = snakeTail.XP;
        Color newColor;

        if (amount > PlayerLives * 1.2f)
        {
            newColor = gameManager.ImpossiblyColor;
        }
        else if (amount >= PlayerLives)
        {
            newColor = gameManager.HardColor;
        }
        else if (amount >= PlayerLives / 2f)
        {
            newColor = gameManager.MiddleColor;
        }
        else 
        {
            newColor = gameManager.EasyColor;
        }
        spriteRenderer.color = newColor;
    }

    public void SnakeDamage() 
    {
        SetAmountText();
        if (amount <= 0)
        {
            gameObject.SetActive(false);
        }
        else if (amount > 0) 
        {
            StartCoroutine(DamageEffect());
        }
    }
    IEnumerator DamageEffect() 
    {
        float timer = 0;
        while (timer < gameManager.damageTime)
        {
            amount--;
            EffectPrefab.SetActive(true);
            timer += Time.deltaTime;
            yield return new WaitForSeconds(0.2f);
        }
    }
    private void OnCollisionStay2D(Collision2D col)
    {
        if (col.gameObject.CompareTag("Player")) 
        {
            SnakeDamage();
        }
    }